<?php
/**
 * This class wil handle all the admin POST requests for forms
 *
 * @package wp-events/admin
 * @subpackage wp-events/admin/includes
 */

/**
 * If this file is called directly, abort.
 */
if ( ! defined( 'WPINC' ) ) {
	die;
}

class Wp_Admin_Request {

    /**
     * handles ajax request for resend notification
     * when entry is edited
     *
     * @since 1.2.0
     */
    public function wpe_resend_notification() {

        $security = isset( $_POST['security'] ) ? sanitize_text_field( wp_unslash( $_POST['security'] ) ) : '';
        if ( ! wp_verify_nonce( $security, 'wpe_resend_notification_nonce' ) ) {
            wp_send_json_error( 'Invalid nonce' );
     
        }   

		$formData          = isset( $_POST['formData'] ) ?  wp_unslash( $_POST['formData'] ) : []; // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Custom sanitization used
        $tab               = isset( $_POST['displayTab'] ) ? sanitize_text_field( wp_unslash($_POST['displayTab']) ) : 'registrations';
        $admin_notification = isset($_POST['adminNoti']) ? sanitize_text_field(wp_unslash($_POST['adminNoti'])) : '';
        $user_notification  = isset($_POST['userNoti']) ? sanitize_text_field(wp_unslash($_POST['userNoti'])) : '';
        $mail_options      = get_option('wpe_mail_settings');
        $firm_info         = get_option('wpe_firm_settings');
        $from_name         = $firm_info['mail_from_name'];
		$from_email        = $mail_options['mail_from'];
		$headers[]         = 'Content-Type: text/html;';
		$headers[]         = "from: $from_name <$from_email>";

        Wpe_Shortcodes::set_form_data( $formData );

        if( !isset( $formData ) || $formData == '' ) {
            wpe_send_ajax_response( 0 );
        }

        if ( empty($admin_notification) && empty($user_notification) ) {
            wp_send_json(2); // Please select a checkbox
        }

        if($admin_notification == "1"){
            $admin_subject = 'Entry Edited for '.do_shortcode("[wpe_event_name]");
            $admin_message = 'This is an auto-generated email confirming change in an event reservation made from your website.<br />
            <br />
            Event Details:<br />
            [wpe_event_details]<br />
            User Details:<br />
            [wpe_registration_details]<br />
            The above visitor information has been added to the WordPress Event database. You can access this information by going to your Website WordPress Dashboard.';
            $admin_message = do_shortcode( $admin_message, TRUE );
            $admin_subject = html_entity_decode( $admin_subject );
            wp_mail( $firm_info['admin_mail'], $admin_subject, $admin_message, $headers );
        }
        
        if($user_notification == "1" ) {
            $to       = $formData['wpe_email'];
            $subject  = 'Your registration for '. do_shortcode("[wpe_event_name]") .' is Edited';
            $message  = 'Dear [wpe_user_first_name] [wpe_user_last_name],<br />
            Thank you for registering for our upcoming Event. This is an auto-generated email confirming change of details for your registration for our upcoming Event. <br />
            <br />
            The new details of your registration are following.<br />
            [wpe_event_details] <br />
            [wpe_registration_details]<br />
            If you have any questions, please feel free to contact us at our office number or via email.<br />
            We look forward to seeing you.<br />
            Sincerely,';
            $message  = do_shortcode( $message, TRUE );
            $subject  = html_entity_decode( $subject );
            wp_mail( $to, $subject, $message, $headers );
        }

        wpe_send_ajax_response( 1 );

	}

    /**
     * handles ajax request for move to trash button
     * on view entry page
     *
     * @since 1.2.0
     */
    public function wpe_trash_restore() {   
        // Verify Nonce
        if (!isset($_POST['security']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['security'])), 'ajax-nonce')) {
            wp_send_json_error('Invalid nonce');
        } 
    
        // Validate and sanitize input
        $button_text = isset($_POST['text']) ? sanitize_text_field(wp_unslash($_POST['text'])) : '';
        $entry_id = isset($_POST['entryID']) ? absint($_POST['entryID']) : 0;
        $tab = isset($_POST['displayTab']) ? sanitize_text_field(wp_unslash($_POST['displayTab'])) : 'registrations';
    
        // Validate inputs
        if (!in_array($button_text, ['Move To Trash', 'Restore'], true) || $entry_id === 0) {
            wpe_send_ajax_response(0);
        }
    
        // Determine table and status
        $table_name = ($tab === 'registrations') ? 'events_registration' : 'events_subscribers';
        $val = ($button_text === 'Restore') 
            ? ($tab === 'registrations' ? WPE_PENDING : WPE_ACTIVE)
            : WPE_TRASHED;
    
        global $wpdb;
    
        // phpcs:disable WordPress.DB.DirectDatabaseQuery.DirectQuery
        $result = $wpdb->update(
            "{$wpdb->prefix}{$table_name}",
            ['wpe_status' => $val],
            ['id' => $entry_id],
            ['%d'],
            ['%d']
        );
    
        if ($result === false) {
            wpe_send_ajax_response(0); // DB error
        }
    
        // === CACHE INVALIDATION ===
        // 1. Delete cached entry (if it was stored)
        $cache_key = "wpe_entry_{$entry_id}";
        wp_cache_delete($cache_key);
    
        wpe_send_ajax_response(1); // Success
    }

    /**
     * Handles ajax request when approval checkbox is checked/unchecked
     *
     * @since 1.2.0
     */
    public function wpe_update_entry_status() { 
        global $wpdb;
        $table_name = 'events_registration';

        $security = isset( $_POST['security'] ) ? sanitize_text_field( wp_unslash( $_POST['security'] ) ) : '';
        if ( ! wp_verify_nonce( $security, 'wpe_update_entry_status_nonce' ) ) {
            wp_send_json_error( 'Invalid nonce' );
        } 

        $checkbox = isset( $_POST['checkbox'] ) ? sanitize_text_field( wp_unslash( $_POST['checkbox'] ) ) : '';

        if( $checkbox === 'true' ) {
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $update = $wpdb->update(
                "{$wpdb->prefix}$table_name",
                ['wpe_status' => WPE_PENDING],
                ['wpe_status' => WPE_ACTIVE],
                '%d',
                '%d'
            );

            wpe_send_ajax_response( 1 );

        } else {
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $update = $wpdb->update(
                "{$wpdb->prefix}$table_name",
                ['wpe_status' => WPE_ACTIVE],
                ['wpe_status' => WPE_APPROVED],
                '%d',
                '%d'
            );
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $update = $wpdb->update(
                "{$wpdb->prefix}$table_name",
                ['wpe_status' => WPE_ACTIVE],
                ['wpe_status' => WPE_PENDING],
                '%d',
                '%d'
            );
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
            $update2 = $wpdb->update(
                "{$wpdb->prefix}$table_name",
                ['wpe_status' => WPE_TRASH],
                ['wpe_status' => WPE_CANCELLED],
                '%d',
                '%d'
            );
            wpe_send_ajax_response( 1 );
        }
    }

    /**
     * Ajax request for updating location data on edit event page
     *
     * @since 1.3.0
     */
    public function wpe_update_location() { 

        $security = isset( $_POST['security'] ) ? sanitize_text_field( wp_unslash( $_POST['security'] ) ) : '';
        if ( ! wp_verify_nonce( $security, 'wpe_update_location_nonce' ) ) {
            wp_send_json_error( 'Invalid nonce' );
        } 

        $postID  = isset($_POST['locationID']) ? sanitize_text_field( wp_unslash( $_POST['locationID'] ) ) : '';
        $eventID = isset($_POST['eventID']) ? sanitize_text_field( wp_unslash( $_POST['eventID'] ) ) : '';
        $options          = get_option( 'wpe_integration_settings' );
        $pattern          = array( ' ', '-', '&' );
        $wpeObj           = new stdClass();
        if ( $postID === 'xxx' ) {
            $wpeObj->map_url  = '';
        } else {
            $wpeObj->map_url  = get_post_meta( $eventID, 'wpevent-map-url', true ) ? get_post_meta( $eventID, 'wpevent-map-url', true ) : '';
        }
        $wpeObj->venue    = get_post_meta( $postID, 'wpevent-loc-venue', true ) ? get_post_meta( $postID, 'wpevent-loc-venue', true ) : '';
        $venue            = str_replace( $pattern, '+', $wpeObj->venue) ?? '';
        $wpeObj->address  = get_post_meta( $postID, 'wpevent-loc-address', true ) ? get_post_meta( $postID, 'wpevent-loc-address', true ) : '';
        $address          = str_replace( $pattern, '+', $wpeObj->address) ?? '';
        $wpeObj->country  = get_post_meta( $postID, 'wpevent-loc-country', true ) ? get_post_meta( $postID, 'wpevent-loc-country', true ) : '';
        $wpeObj->city     = get_post_meta( $postID, 'wpevent-loc-city', true ) ? get_post_meta( $postID, 'wpevent-loc-city', true ) : '';
        $city             = str_replace( $pattern, '+', $wpeObj->city) ?? '';
        $wpeObj->state    = get_post_meta( $postID, 'wpevent-loc-state', true ) ? get_post_meta( $postID, 'wpevent-loc-state', true ) : '';
        $state            = str_replace( $pattern, '+', $wpeObj->state) ?? '';
        $wpeObj->zip      = get_post_meta( $postID, 'wpevent-loc-zip', true ) ? get_post_meta( $postID, 'wpevent-loc-zip', true ) : '';
        if( $venue !== '' || $address !== '' || $city !== '' || $state !== '' ) {
            $wpeObj->map_url  = "https://www.google.com/maps/place?q=" . $venue . '+' . $address . "," . $city . '+' . $state;
        }
        $location_obj     = json_encode( $wpeObj );
        wpe_send_ajax_response( $location_obj );
    }

    /**
     * Ajax request for creating new location in location CPT
     *
     * @since 1.3.0
     */
    public function wpe_create_location() {

        //Verify Nonce
        $security = isset( $_POST['security'] ) ? sanitize_text_field( wp_unslash( $_POST['security'] ) ) : '';
        if ( ! wp_verify_nonce( $security, 'ajax-nonce' ) ) {
            wp_send_json_error( 'Invalid nonce' );
        } 
    
        
        $raw_location_data = isset( $_POST['location'] ) ? sanitize_text_field( wp_unslash( $_POST['location'] )) : array();

        $venue   = isset( $raw_location_data['venue'] ) ? sanitize_text_field( stripslashes( $raw_location_data['venue'] ) ) : '';
        $address = isset( $raw_location_data['address'] ) ? sanitize_text_field( $raw_location_data['address'] ) : '';
        $country = isset( $raw_location_data['country'] ) && $raw_location_data['country'] !== 'Select Country' ? sanitize_text_field( $raw_location_data['country'] ) : '';
        $city    = isset( $raw_location_data['city'] ) ? sanitize_text_field( $raw_location_data['city'] ) : '';
        $state   = isset( $raw_location_data['state'] ) ? sanitize_text_field( $raw_location_data['state'] ) : '';
        $zip     = isset( $raw_location_data['zip'] ) ? sanitize_text_field( $raw_location_data['zip'] ) : '';
        
        if ( empty( $venue ) ) {
            wpe_send_ajax_response( 'Please enter location(venue) title' );
        }
    
        //Prepare post array
        $post_arr = array(
            'post_title'  => $venue,
            'post_type'   => 'locations',
            'post_status' => 'publish',
            'meta_input'  => array(
                'wpevent-loc-venue'   => $venue,
                'wpevent-loc-address' => $address,
                'wpevent-loc-country' => $country,
                'wpevent-loc-city'    => $city,
                'wpevent-loc-state'   => $state,
                'wpevent-loc-zip'     => $zip,
            ),
        );
    
        // Check for duplicates
        $args = array(
            'post_type'      => 'locations',
            'posts_per_page' => -1,
            'post_status'    => 'publish',
        );
    
        $locations = get_posts( $args );
        foreach ( $locations as $location ) {
            if ( $location->post_title === $venue ) {
                wpe_send_ajax_response( 'Location Already Exists!' );
            }
        }

        //insert post
        $post_id = wp_insert_post( $post_arr );
        wpe_send_ajax_response( $post_id );
    }
    

    /**
     * Ajax request for updating all seminars confirmation when message
     * is updated in settings.
     *
     * @since 1.6.0
     */
    public function wpe_update_confirmation() {
        global $wpdb;
    
        // Verify Nonce
        $security = isset( $_POST['security'] ) ? sanitize_text_field( wp_unslash( $_POST['security'] ) ) : '';
        if ( ! wp_verify_nonce( $security, 'ajax-nonce' ) ) {
            wp_send_json_error( 'Invalid nonce' );
        }
    
        $type    = isset( $_POST['type'] ) ? sanitize_text_field( wp_unslash( $_POST['type'] ) ) : '';
        $message = isset( $_POST['message'] ) ? wp_kses( wp_unslash( $_POST['message'] ), wpe_get_allowed_html() ) : '';
    
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
        $post_ids = $wpdb->get_col( $wpdb->prepare(
            "
            SELECT p.ID
            FROM {$wpdb->posts} p
            INNER JOIN {$wpdb->postmeta} pm ON p.ID = pm.post_id
            WHERE p.post_type = 'wp_events'
            AND p.post_status = 'publish'
            AND pm.meta_key = 'wpevent-type'
            AND pm.meta_value = %s
            ",
            $type
        ) );
    
        if ( ! empty( $post_ids ) ) {
            foreach ( $post_ids as $post_id ) {
                update_post_meta( $post_id, 'wpevent-confirmation-message', $message );
            }
            wpe_send_ajax_response( 1 );
        }
    
        wpe_send_ajax_response( 0 );
    }    

    /**
     * Ajax request for sending event reminder to registrants
     * 
     * @since 1.7.6
     */
    public function wpe_event_reminder() {

        // Verify Nonce
        $security = isset( $_POST['security'] ) ? sanitize_text_field( wp_unslash( $_POST['security'] ) ) : '';
        if ( ! wp_verify_nonce( $security, 'ajax-nonce' ) ) {
            wp_send_json_error( 'Invalid nonce' );
        }
    
        // Validate and sanitize postID
        $post_id = isset( $_POST['postID'] ) ? sanitize_text_field( wp_unslash( $_POST['postID'] ) ) : '';
    
        if ( empty( $post_id ) ) {
            wp_send_json_error( 'Missing post ID' );
        }
    
        $response = wpe_auto_email( $post_id );
        wpe_send_ajax_response( $response );
    }
    
}